<?php

defined('ABSPATH') || die('No direct access!');

class wp_video_uploader 
{
	const VERSION = 'wp-video-uploader 1.0.2';
	const textdomain = 'wp-video-uploader';
	private static $plugin_name = 'wp-video-uploader';

	/**
	 * do the stuff
	 */
	public static function init() 
	{
		// add editor button
		add_action('media_buttons', array(__CLASS__, 'add_media_button'), 20);
		register_activation_hook(POLYV_LOADER, array(__CLASS__, 'my_activation'));
		register_deactivation_hook(POLYV_LOADER, array(__CLASS__, 'my_deactivation'));
	}

	public static function add_media_button($editor_id = 'content')
	{
		?>
		<a href="<?php echo esc_url($url) ?>" class="wp-video-uploader v_upload_btn" id="<?php echo esc_attr($editor_id)?>-hacklog_ria" onclick="return false;">上传视频</a>
		<script>
			var writetoken = "please change the token";
			var readtoken = "please change the token";
			setTimeout(function(){
				POLYVJQUERY.polyv.insertHtml = function(thumbnail, html) {
					set_data("<p><img src="+thumbnail+"></p><p>"+html+"</p>");
					POLYVJQUERY(".jquery-dialog").trigger("cancel");
				}
			}, 4000);
			function get_data() {
				if (window.KindEditor){
					return window.editor.html();
				} else {
					return CKEDITOR.instances.body.getData(); 
				}
			}
			function set_data(html) {
				if (window.KindEditor){
					window.editor.html(html);
				} else if (window.CKEDITOR) {
					CKEDITOR.instances.body.setData(html); 
				} else {
					tinyMCE.execCommand('mceInsertContent',false,html);  
				}
			}
		</script>
		<script src="http://static.polyv.net/caret/v_uploader.js"></script>
		<?php
	}

	public static function my_activation() {}
	public static function my_deactivation() {}

} //end class
?>
